<?php
include 'index.php';
?>
<section class="pc-container">
    <div class="pc-content">
        <div class="row">
            <div class="mb-4 d-flex justify-content-between align-items-center">
                <h2 class="mb-0">Data Gudang</h2>
                <button class="btn btn-success rounded" data-bs-toggle="modal" data-bs-target="#addGudangModal">
                    <i class="ti ti-plus"></i> Tambah Gudang
                </button>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">
                        <h5>Daftar Gudang</h5>
                        <small>Kelola data gudang penyimpanan</small>
                    </div>
                    <div class="card-body">
                        <div class="dt-responsive">
                            <table id="dom-jqry" class="table table-striped table-bordered nowrap">
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Nama Gudang</th>
                                        <th>Lokasi</th>
                                        <th>Keterangan</th>
                                        <th class="text-center">Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $query = "SELECT * FROM gudang ORDER BY id_gudang DESC";
                                    $result = mysqli_query($conn, $query);
                                    $no = 1;
                                    while ($row = mysqli_fetch_assoc($result)) {
                                    ?>
                                    <tr>
                                        <td><?= $no++ ?></td>
                                        <td><?= $row['nama_gudang'] ?></td>
                                        <td><?= $row['lokasi'] ?></td>
                                        <td><?= $row['keterangan'] ?></td>
                                        <td class="text-center">
                                            <button class="btn btn-warning btn-sm" data-bs-toggle="modal" data-bs-target="#editGudangModal<?php echo $row['id_gudang']; ?>" title="Edit">
                                                <i class="ti ti-edit"></i>
                                            </button>
                                            <button class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#deleteGudangModal<?php echo $row['id_gudang']; ?>" title="Hapus">
                                                <i class="ti ti-trash"></i>
                                            </button>
                                        </td>
                                    </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Modal Tambah Gudang -->
<div class="modal fade" id="addGudangModal" tabindex="-1" aria-labelledby="addGudangModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addGudangModalLabel">Tambah Gudang</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="addGudangForm" action="tambahgudang.php" method="POST">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="nama_gudang" class="form-label">Nama Gudang</label>
                        <input type="text" class="form-control" id="nama_gudang" name="nama_gudang" placeholder="Contoh: Gudang A, Gudang Utama" required>
                    </div>
                    <div class="mb-3">
                        <label for="lokasi" class="form-label">Lokasi</label>
                        <input type="text" class="form-control" id="lokasi" name="lokasi" placeholder="Contoh: Jl. Raya No. 123, Jakarta" required>
                    </div>
                    <div class="mb-3">
                        <label for="keterangan" class="form-label">Keterangan</label>
                        <textarea class="form-control" id="keterangan" name="keterangan" rows="3" placeholder="Keterangan tambahan (opsional)"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Tutup</button>
                    <button type="submit" class="btn btn-success" name="tambah">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php
    $query = "SELECT * FROM gudang ORDER BY id_gudang DESC";
    $result = mysqli_query($conn, $query);
    while ($row = mysqli_fetch_assoc($result)) {
?>
<!-- Modal Edit Gudang -->
<div class="modal fade" id="editGudangModal<?php echo $row['id_gudang']; ?>" tabindex="-1" aria-labelledby="editGudangModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editGudangModalLabel">Edit Gudang</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="editGudangForm" action="editgudang.php" method="POST">
                <input type="hidden" name="id_gudang" value="<?php echo $row['id_gudang']; ?>">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="edit_nama_gudang<?php echo $row['id_gudang']; ?>" class="form-label">Nama Gudang</label>
                        <input type="text" class="form-control" id="edit_nama_gudang<?php echo $row['id_gudang']; ?>" name="nama_gudang" value="<?php echo $row['nama_gudang']; ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="edit_lokasi<?php echo $row['id_gudang']; ?>" class="form-label">Lokasi</label>
                        <input type="text" class="form-control" id="edit_lokasi<?php echo $row['id_gudang']; ?>" name="lokasi" value="<?php echo $row['lokasi']; ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="edit_keterangan<?php echo $row['id_gudang']; ?>" class="form-label">Keterangan</label>
                        <textarea class="form-control" id="edit_keterangan<?php echo $row['id_gudang']; ?>" name="keterangan" rows="3"><?php echo $row['keterangan']; ?></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Tutup</button>
                    <button type="submit" class="btn btn-warning" name="edit">Simpan Perubahan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Hapus Gudang -->
<div class="modal fade" id="deleteGudangModal<?php echo $row['id_gudang']; ?>" tabindex="-1" aria-labelledby="deleteGudangModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteGudangModalLabel">Konfirmasi Hapus</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="deleteGudangForm" action="hapusgudang.php" method="POST">
                <input type="hidden" name="id_gudang" value="<?php echo $row['id_gudang']; ?>">
                <div class="modal-body">
                    <p>Apakah Anda yakin ingin menghapus gudang <strong><?php echo $row['nama_gudang']; ?></strong>?</p>
                    <div class="alert alert-warning">
                        <i class="ti ti-alert-triangle"></i> Data yang dihapus tidak dapat dikembalikan!
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-danger" name="hapus">Hapus</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php } ?>

<?php include 'footer.php'; ?>